% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

%% Run impulse response functions

% Shock occurs in period 1 of the simulation
T               = 30;

% A shocks
% Sequence of random innovations
if strcmp(agg_shock,'A')
    sig         = 0.01; %PARMS.sigA*sqrt(1-PARMS.rhoA^2); % scales the innovations
else
    sig         = 0;
end
logA            = zeros(T,1);
logA(1)         = logA(1) + sig;
for tt = 2:T
    logA(tt)    = PARMS.rhoA * logA(tt-1);
end
At              = exp(logA); %#ok<*NASGU>
clear logA

% B shocks
if strcmp(agg_shock,'F')
    sig         = 0.01; 
else
    sig         = 0;
end
logF            = zeros(T,1);
logF(1)         = logF(1) - sig;
for tt = 2:T
    logF(tt)    = PARMS.rhoF * logF(tt-1);
end
Ft              = exp(logF) * PARMS.F_upper;
clear logF

% Initialize

pit     = zeros(T,1);
ct      = zeros(T,1);
mu_at   = ones(T,1) * mu_a;
phi_at  = ones(T,1) * phi_a;
mu_nt   = ones(T,1) * mu_n;
phi_nt  = ones(T,1) * phi_n;
kt      = ones(T,PARMS.N).*k_a';

% Run simulation
run_sim

% Compute additional output
y_at    = PARMS.meaneps*mu_at + phi_at; % Net of aggregate productivity
y_nt    = PARMS.meaneps*mu_nt + phi_nt; % Net of aggregate productivity
ACt     = pit.^2 / 2 .* Ft;
Yt      = At .* (pit.*y_at + (1-pit).*y_nt ) ;
SRt     = Yt; % Solow residual

% Compute reallocation and dispersion
compute_R_sigma

% percentage deviations from steady state
Atilde          = log(At)-log(At(1));
SRtilde         = log(SRt)-log(SRt(1)); % Solow residual
Ftilde          = log(Ft)-log(Ft(1));
Ytilde          = log(Yt)-log(Yt(1));
ACtilde         = log(ACt)-log(ACt(1));
Ctilde          = log(ct)-log(ct(1));
PItilde         = log(pit)-log(pit(1));
Rtilde          = log(Rt)-log(Rt(1));
SIGtilde        = log(sigt) - log(sigt(1));
MUntilde        = log(mu_nt)-log(mu_nt(1));
MUatilde        = log(mu_at)-log(mu_at(1));
PHIntilde       = log(phi_nt)-log(phi_nt(1));
PHIatilde       = log(phi_at)-log(phi_at(1));

% Save results
if strcmp(agg_shock,'A')
    IRF_Fig_4   = [Atilde, SRtilde, MUntilde, MUatilde, PHIntilde, PHIatilde, PItilde, ACtilde, Rtilde, SIGtilde];
    writematrix(IRF_Fig_4,sprintf('%s/Figure4_data.csv',PARMS.figfolder))
elseif strcmp(agg_shock,'F')
    IRF_Fig_5   = [Ftilde, SRtilde, MUntilde, MUatilde, PHIntilde, PHIatilde, PItilde, ACtilde, Rtilde, SIGtilde];
    writematrix(IRF_Fig_5,sprintf('%s/Figure5_data.csv',PARMS.figfolder))
end

